<?php
/**
 * Plugin Name: QR Jump
 * Plugin URI: https://murrinmedia.com.au
 * Description: Generate QR codes that route through your WordPress site for trackable redirects, dynamic destination changes, and scan analytics.
 * Version: 1.0.0
 * Author: MurrinMedia
 * Author URI: https://murrinmedia.com.au
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: qr-jump
 * Domain Path: /languages
 */

// If this file is called directly, abort.
if (!defined('WPINC')) {
    die;
}

// Define plugin constants
define('QR_JUMP_VERSION', '1.0.3');
define('QR_JUMP_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('QR_JUMP_PLUGIN_URL', plugin_dir_url(__FILE__));

// Include required files
require_once QR_JUMP_PLUGIN_DIR . 'includes/class-qr-jump-activator.php';
require_once QR_JUMP_PLUGIN_DIR . 'includes/class-qr-jump-updater.php';
require_once QR_JUMP_PLUGIN_DIR . 'includes/class-qr-jump.php';

// Initialize the updater
function qr_jump_init_updater() {
    QR_Jump_Updater::get_instance(__FILE__)->check_update();
}
add_action('admin_init', 'qr_jump_init_updater');

// Activation hook
register_activation_hook(__FILE__, array('QR_Jump_Activator', 'activate'));

// Initialize the plugin
function run_qr_jump() {
    $plugin = new QR_Jump();
    $plugin->run();
}
run_qr_jump(); 