jQuery(document).ready(function($) {
    // Handle QR code download
    $('.qr-jump-download').on('click', function(e) {
        e.preventDefault();
        
        var $link = $(this);
        var $img = $link.siblings('img');
        
        // Create a temporary canvas to ensure high-quality download
        var canvas = document.createElement('canvas');
        var ctx = canvas.getContext('2d');
        var img = new Image();
        
        img.onload = function() {
            canvas.width = img.width;
            canvas.height = img.height;
            ctx.drawImage(img, 0, 0);
            
            // Convert to blob and trigger download
            canvas.toBlob(function(blob) {
                var url = URL.createObjectURL(blob);
                var a = document.createElement('a');
                a.href = url;
                a.download = 'qr-code.png';
                document.body.appendChild(a);
                a.click();
                document.body.removeChild(a);
                URL.revokeObjectURL(url);
            });
        };
        
        img.src = $img.attr('src');
    });

    // Add loading state to QR code container
    $('.qr-jump-container').each(function() {
        var $container = $(this);
        var $img = $container.find('img');
        
        $img.on('load', function() {
            $container.addClass('loaded');
        });
    });
}); 