<?php

class QR_Jump {
    protected $loader;
    protected $plugin_name;
    protected $version;

    public function __construct() {
        $this->version = QR_JUMP_VERSION;
        $this->plugin_name = 'qr-jump';

        $this->load_dependencies();
        $this->define_admin_hooks();
        $this->define_public_hooks();
        $this->define_post_types();
    }

    private function load_dependencies() {
        require_once QR_JUMP_PLUGIN_DIR . 'includes/class-qr-jump-loader.php';
        require_once QR_JUMP_PLUGIN_DIR . 'admin/class-qr-jump-admin.php';
        require_once QR_JUMP_PLUGIN_DIR . 'public/class-qr-jump-public.php';
        require_once QR_JUMP_PLUGIN_DIR . 'includes/class-qr-jump-post-types.php';
        require_once QR_JUMP_PLUGIN_DIR . 'includes/class-qr-jump-qr-generator.php';
        require_once QR_JUMP_PLUGIN_DIR . 'includes/class-qr-jump-analytics.php';

        $this->loader = new QR_Jump_Loader();
    }

    private function define_admin_hooks() {
        $plugin_admin = new QR_Jump_Admin($this->get_plugin_name(), $this->get_version());

        $this->loader->add_action('admin_enqueue_scripts', $plugin_admin, 'enqueue_styles');
        $this->loader->add_action('admin_enqueue_scripts', $plugin_admin, 'enqueue_scripts');
    }

    private function define_public_hooks() {
        $plugin_public = new QR_Jump_Public($this->get_plugin_name(), $this->get_version());

        $this->loader->add_action('wp_enqueue_scripts', $plugin_public, 'enqueue_styles');
        $this->loader->add_action('wp_enqueue_scripts', $plugin_public, 'enqueue_scripts');
        $this->loader->add_action('init', $plugin_public, 'register_shortcodes');
        $this->loader->add_action('init', $plugin_public, 'handle_qr_redirect');
    }

    private function define_post_types() {
        $post_types = new QR_Jump_Post_Types();
        $this->loader->add_action('init', $post_types, 'register_post_types');
        $this->loader->add_action('init', $post_types, 'register_taxonomies');
    }

    public function run() {
        $this->loader->run();
    }

    public function get_plugin_name() {
        return $this->plugin_name;
    }

    public function get_version() {
        return $this->version;
    }
} 