<?php

class QR_Jump_Post_Types {
    public function register_post_types() {
        $labels = array(
            'name'               => _x('QR Jump', 'post type general name', 'qr-jump'),
            'singular_name'      => _x('QR Code', 'post type singular name', 'qr-jump'),
            'menu_name'          => _x('QR Jump', 'admin menu', 'qr-jump'),
            'add_new'            => _x('Add New', 'qr code', 'qr-jump'),
            'add_new_item'       => __('Add New QR Code', 'qr-jump'),
            'edit_item'          => __('Edit QR Code', 'qr-jump'),
            'new_item'           => __('New QR Code', 'qr-jump'),
            'view_item'          => __('View QR Code', 'qr-jump'),
            'search_items'       => __('Search QR Codes', 'qr-jump'),
            'not_found'          => __('No QR codes found', 'qr-jump'),
            'not_found_in_trash' => __('No QR codes found in Trash', 'qr-jump'),
        );

        $args = array(
            'labels'              => $labels,
            'public'              => true,
            'publicly_queryable'  => true,
            'show_ui'            => true,
            'show_in_menu'       => true,
            'query_var'          => true,
            'rewrite'            => array('slug' => 'qr-code'),
            'capability_type'    => 'post',
            'has_archive'        => false,
            'hierarchical'       => false,
            'menu_position'      => null,
            'menu_icon'          => plugin_dir_url(__DIR__) . 'admin/css/qrjump-dashicon.png',
            'supports'           => array('title', 'custom-fields'),
            'show_in_rest'       => true,
            'menu_title'         => __('QR Jump', 'qr-jump'),
        );

        register_post_type('qr_code', $args);

        add_filter('wp_insert_post_data', array($this, 'set_random_slug_for_qr_code'), 10, 2);
    }

    public function set_random_slug_for_qr_code($data, $postarr) {
        if (
            $data['post_type'] === 'qr_code' &&
            $data['post_status'] === 'auto-draft' &&
            empty($data['post_name'])
        ) {
            // Only set slug for new posts with no slug
            $data['post_name'] = $this->generate_unique_random_slug();
        }
        return $data;
    }

    public function generate_unique_random_slug($length = 5) {
        global $wpdb;
        $table = $wpdb->posts;
        do {
            $slug = strtolower(substr(str_shuffle('abcdefghijklmnopqrstuvwxyz0123456789'), 0, $length));
            $exists = $wpdb->get_var($wpdb->prepare("SELECT ID FROM $table WHERE post_name = %s", $slug));
        } while ($exists);
        return $slug;
    }

    public function register_taxonomies() {
        // Register QR Code Categories
        $labels = array(
            'name'              => _x('QR Code Categories', 'taxonomy general name', 'qr-jump'),
            'singular_name'     => _x('QR Code Category', 'taxonomy singular name', 'qr-jump'),
            'search_items'      => __('Search QR Code Categories', 'qr-jump'),
            'all_items'         => __('All QR Code Categories', 'qr-jump'),
            'parent_item'       => __('Parent QR Code Category', 'qr-jump'),
            'parent_item_colon' => __('Parent QR Code Category:', 'qr-jump'),
            'edit_item'         => __('Edit QR Code Category', 'qr-jump'),
            'update_item'       => __('Update QR Code Category', 'qr-jump'),
            'add_new_item'      => __('Add New QR Code Category', 'qr-jump'),
            'new_item_name'     => __('New QR Code Category Name', 'qr-jump'),
            'menu_name'         => __('Categories', 'qr-jump'),
        );

        $args = array(
            'hierarchical'      => true,
            'labels'            => $labels,
            'show_ui'           => true,
            'show_admin_column' => true,
            'query_var'         => true,
            'rewrite'           => array('slug' => 'qr-category'),
            'show_in_rest'      => true,
        );

        register_taxonomy('qr_category', array('qr_code'), $args);
    }
} 