<?php

class QR_Jump_Activator {
    public static function activate() {
        global $wpdb;

        // Start transaction
        $wpdb->query('START TRANSACTION');

        try {
            // Create database tables
            self::create_database_tables();

            // Set up rewrite rules
            self::setup_rewrite_rules();

            // Set initial version
            update_option('qr_jump_version', QR_JUMP_VERSION);

            // Commit transaction
            $wpdb->query('COMMIT');

            // Clear any caches
            wp_cache_flush();

        } catch (Exception $e) {
            // Rollback on error
            $wpdb->query('ROLLBACK');
            error_log('QR Jump activation failed: ' . $e->getMessage());
            wp_die('Plugin activation failed. Please try again or contact support.');
        }
    }

    private static function create_database_tables() {
        global $wpdb;
        $charset_collate = $wpdb->get_charset_collate();

        // Table for QR code analytics
        $table_name = $wpdb->prefix . 'qr_jump_analytics';
        $sql = "CREATE TABLE IF NOT EXISTS $table_name (
            id bigint(20) NOT NULL AUTO_INCREMENT,
            qr_id bigint(20) NOT NULL,
            scan_date datetime DEFAULT CURRENT_TIMESTAMP NOT NULL,
            ip_address varchar(45) NOT NULL,
            user_agent text NOT NULL,
            referrer text,
            country varchar(2),
            city varchar(100),
            latitude decimal(10,8),
            longitude decimal(11,8),
            PRIMARY KEY  (id),
            KEY qr_id (qr_id),
            KEY scan_date (scan_date)
        ) $charset_collate;";

        require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
        dbDelta($sql);
    }

    private static function setup_rewrite_rules() {
        // Add rewrite rules for QR code redirects
        add_rewrite_rule(
            'qr/([^/]+)/?$',
            'index.php?qr_code=$matches[1]',
            'top'
        );

        // Add rewrite tag
        add_rewrite_tag('%qr_code%', '([^&]+)');

        // Flush rewrite rules
        flush_rewrite_rules();
    }
} 