jQuery(document).ready(function($) {
    // Live preview of QR code when changing color or size
    function updateQRPreview() {
        var $form = $('.qr-jump-meta-box');
        var $preview = $('.qr-code-preview');
        
        if (!$preview.length) {
            return;
        }

        var data = {
            action: 'qr_jump_preview',
            nonce: qrJumpAdmin.nonce,
            color: $('#qr_jump_color').val(),
            size: $('#qr_jump_size').val()
        };

        $.post(qrJumpAdmin.ajaxUrl, data, function(response) {
            if (response.success && response.data.qr_image) {
                $preview.find('img').attr('src', response.data.qr_image);
            }
        });
    }

    // Update preview when color or size changes
    $('#qr_jump_color, #qr_jump_size').on('change', updateQRPreview);

    // Function to handle field states
    function handleFields() {
        var $scanLimit = $('#qr_jump_scan_limit');
        var $expiryDate = $('#qr_jump_expiry_date');
        
        // Always start with both fields enabled
        $scanLimit.prop('disabled', false);
        $expiryDate.prop('disabled', false);

        // Check if either field has a value
        var hasScanLimit = $scanLimit.val() && parseInt($scanLimit.val()) > 0;
        var hasExpiryDate = $expiryDate.val() && $expiryDate.val().length > 0;

        // If scan limit is set, disable expiry date
        if (hasScanLimit) {
            $expiryDate.prop('disabled', true);
            $expiryDate.val('');
        }
        // If expiry date is set, disable scan limit
        else if (hasExpiryDate) {
            $scanLimit.prop('disabled', true);
            $scanLimit.val('');
        }
    }

    // Handle changes to both fields
    $('#qr_jump_scan_limit').on('input change', function() {
        handleFields();
    });

    $('#qr_jump_expiry_date').on('input change', function() {
        handleFields();
    });

    // Initial setup
    handleFields();

    // Destination field validation
    $('#qr_jump_destination').on('input', function() {
        var $field = $(this);
        var value = $field.val().trim();
        var $description = $field.siblings('.description');
        
        if (value === '') {
            $field.removeClass('valid-url valid-vcard invalid');
            return;
        }
        
        // Check if it's a vCard
        if (value.startsWith('BEGIN:VCARD')) {
            $field.removeClass('valid-url invalid').addClass('valid-vcard');
            if (!$description.find('.vcard-status').length) {
                $description.append('<span class="vcard-status" style="color: #46b450;">✓ Valid vCard format</span>');
            }
        }
        // Check if it's a valid URL
        else if (isValidUrl(value)) {
            $field.removeClass('valid-vcard invalid').addClass('valid-url');
            if (!$description.find('.url-status').length) {
                $description.append('<span class="url-status" style="color: #46b450;">✓ Valid URL format</span>');
            }
        }
        // Invalid format
        else {
            $field.removeClass('valid-url valid-vcard').addClass('invalid');
            if (!$description.find('.invalid-status').length) {
                $description.append('<span class="invalid-status" style="color: #dc3232;">⚠ Please enter a valid URL or vCard data</span>');
            }
        }
    });

    // URL validation helper
    function isValidUrl(string) {
        try {
            new URL(string);
            return true;
        } catch (_) {
            return false;
        }
    }

    // Handle bulk actions
    $('.wp-list-table').on('change', 'select[name="action"]', function() {
        var action = $(this).val();
        if (action === 'export_csv') {
            var ids = [];
            $('input[name="post[]"]:checked').each(function() {
                ids.push($(this).val());
            });
            
            if (ids.length === 0) {
                return;
            }

            var data = {
                action: 'qr_jump_export_csv',
                nonce: qrJumpAdmin.nonce,
                ids: ids
            };

            $.post(qrJumpAdmin.ajaxUrl, data, function(response) {
                if (response.success && response.data.file_url) {
                    window.location.href = response.data.file_url;
                }
            });
        }
    });

    if ($('#qr-jump-send-test-email').length) {
        $('#qr-jump-send-test-email').on('click', function(e) {
            e.preventDefault();
            var $btn = $(this);
            var $result = $('#qr-jump-test-email-result');
            var emails = $('input[name="qr_jump_notification_emails"]').val();
            var format = $('input[name="qr_jump_notification_email_format"]:checked').val();
            $btn.prop('disabled', true);
            $result.text('Sending...');

            var data = {
                action: 'qr_jump_send_test_email',
                nonce: qrJumpAdmin.nonce,
                emails: emails,
                format: format
            };

            $.post(qrJumpAdmin.ajaxUrl, data, function(response) {
                if (response.success) {
                    $result.text('Test email sent successfully!');
                    $result.css('color', 'green');
                } else {
                    $result.text('Error sending test email: ' + response.data.message);
                    $result.css('color', 'red');
                }
                $btn.prop('disabled', false);
            });
        });
    }

    // Hide both rows by default
    $('#qr-jump-weekly-row').hide();
    $('#qr-jump-monthly-row').hide();
    function toggleNotificationDayFields() {
        var freq = $('input[name="qr_jump_notification_frequency"]:checked').val();
        var $weeklyRow = $('#qr-jump-weekly-row');
        var $monthlyRow = $('#qr-jump-monthly-row');
        if (freq === 'weekly') {
            $weeklyRow.show();
            $monthlyRow.hide();
        } else if (freq === 'monthly') {
            $weeklyRow.hide();
            $monthlyRow.show();
        } else {
            $weeklyRow.hide();
            $monthlyRow.hide();
        }
    }
    if ($('input[name="qr_jump_notification_frequency"]').length) {
        toggleNotificationDayFields();
        $('input[name="qr_jump_notification_frequency"]').on('change', toggleNotificationDayFields);
    }
}); 