# QR Jump for WordPress

QR Jump is a WordPress plugin that allows you to generate QR codes that route through your WordPress site for trackable redirects, dynamic destination changes, and scan analytics.

## Features

- Create QR codes with customizable colors and sizes
- Track QR code scans with detailed analytics
- Set expiration dates or scan limits for QR codes
- View scan statistics including geolocation data
- Export scan data to CSV
- Embed QR codes using shortcodes or Gutenberg blocks
- Change destination URLs anytime without updating the QR code

## Requirements

- WordPress 5.0 or higher
- PHP 7.4 or higher
- Composer (for dependency management)

## Installation

1. Download the plugin files and upload them to your `/wp-content/plugins/qr-jump` directory
2. Navigate to the plugin directory in your terminal and run:
   ```bash
   composer install
   ```
3. Activate the plugin through the WordPress admin interface
4. Go to QR Jump settings and enter your IP-API key for geolocation tracking

## Usage

### Creating QR Codes

1. Go to QR Codes > Add New in your WordPress admin
2. Enter a title for your QR code
3. Set the destination URL
4. Customize the QR code appearance (color, size)
5. Set optional expiration date or scan limit
6. Publish the QR code

### Embedding QR Codes

Use the shortcode to embed a QR code in your posts or pages:

```
[qr_jump id="123" title="My QR Code" show_count="yes" show_download="yes"]
```

Shortcode parameters:
- `id`: The ID of your QR code (required)
- `title`: Optional title to display above the QR code
- `show_count`: Show/hide scan count (yes/no)
- `show_download`: Show/hide download button (yes/no)
- `size`: Custom size in pixels (optional)
- `color`: Custom color in hex format (optional)

### Analytics

View scan statistics for each QR code:
- Total scans
- Unique visitors
- Geographic distribution
- Daily/monthly trends
- Export data to CSV

### Settings

Configure the plugin settings:
- IP-API key for geolocation tracking
- Default QR code appearance
- Analytics retention period

## Support

For support, please create an issue in the GitHub repository or contact the plugin author.

## License

This plugin is licensed under the GPL v2 or later.

## Credits

- QR code generation powered by [endroid/qr-code](https://github.com/endroid/qr-code)
- Geolocation data provided by [IP-API](https://ipapi.co/) 